/* v0.8
 *
 * mux.c:  MUX-specific code.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include "spaceconf.h"
#include "platform.h"
#include "space.h"

/*
 * getAttr:  Fetch an attribute string into the volatile buffer.
 */
char *getAttrByNumber(dbref obj, int attrnum)
{
	dbref aowner;
	int aflags;
	char *atr_gotten;
	static char buff[LARGE_BUF_SIZE];

	atr_gotten = atr_pget(obj, attrnum, &aowner, &aflags);

	strcpy(buff, atr_gotten);
	free_lbuf(atr_gotten);

	return(buff);
}

char *getAttrByName(dbref obj, char *attrname)
{
	ATTR *attr;

	if (!(attr=atr_str(attrname)))
		return("");

	else
		return getAttrByNumber(obj, attr->number);

}

/*
 * getEvalAttr:  Fetch an attribute string, and evaluate it
 */ 
	
char *getEvalAttr(dbref obj, char *attrname, char **cargs, int ncargs)
{
	static char buff[SMALL_BUF_SIZE];
	ATTR *attr;
	dbref aowner;
	int aflags, i;
	char *bp, *atr_gotten;

	if (!(attr=atr_str(attrname)))
		return("");

	bp = buff;
	atr_gotten = getAttrByNumber(obj, attr->number);

	if (*atr_gotten)
		exec(buff, &bp, 0, obj, GOD, EV_EVAL | EV_FIGNORE | EV_TOP,
		  &atr_gotten, cargs, ncargs);

	*bp='\0';

	/* Free up the argument buffers.  Don't need them no more. */
	for (i=0; i < ncargs; i++)
		FreeBuffer(cargs[i]);

	return buff;

}

/*
 * setAttr:  Record an attribute in the database. 
 */
void setAttrByNumber(dbref obj, int attrnum, char *value)
{
	dbref aowner;
	int aflags;
	ATTR *attr;

	if (isGoodObject(obj)) {
		atr_pget_info(obj, attrnum, &aowner, &aflags);
		atr_add(obj, attrnum, value, aowner, aflags);
	}

	return;
}
		
void setAttrByName(dbref obj, char *attrname, char *value)
{

	ATTR *attr;

	if ((attr=atr_str(attrname)) != NULL)
		setAttrByNumber(obj, attr->number, value);

	return;
}
