/* v0.8
 *
 * ship.h:  Ship definition.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

struct channel_entry {
	unsigned frequency;
	int send_status;
	int receive_status;
	char label[17];
};

struct torp_entry {
	int range;
	float base_accuracy;
	int power;
	int charge;
	int time_to_reload;
	int turns_charged;
	int status;
	int charge_per_turn;
};

struct gun_entry {
	int range;
	int power;
	float range_percent;  /* deliverable percent at max range */
	int charge;
	int old_charge;
	int status;
	int charge_per_turn;
};

struct damage_entry {
	char status;
	int teams;
	int maxteams;
	int time_to_fix;
};

struct ship_entry {

	/* identification fields */
	char class[CLASS_LEN];
	char type[TYPE_LEN];
	char owner_name[OWNER_LEN];
	int owner;

	/* Dbrefs of consoles */
	dbref tactical;	   /* dbrefs of the various control consoles */
	dbref shields;
	dbref nav;
	dbref eng;
	dbref trans;
	dbref damcon;
	dbref comm;

	int shipflags;

	/* Hull damage */
	int hull_integrity;
	int current_integrity;
	int permanent_hull_damage;

	/* Reactor fields */
	int reactor_output_max;
	int current_reactor_output_max;
	int reactor_setting;
	int reactor_output;
	int reactor_setting_limit;
	int reactor_stress_level;
	int reactor_overload_penalty;
  	int reactor_drain;
 
	int max_overload_points;
	int overload_points;

	/* Battery fields */   
	int battery_capacity;
	int battery_level;
	int battery_discharge_max;
	int battery_discharge;
	char battery_status;

	/* Engineering fields */
	int eng_warnings;
	int eng_safeties;

	/* Engine fields */
	float warp_factor;
	float warp_max;
	float warp_speed;

	int scanner_range;

	/* Communications fields */
	float transmitter_range;
	float receiver_sensitivity;
	struct channel_entry channel[MAX_CHANNELS];

	/* Shield/door fields */
	int shield_level[4];
	int shield_alloc[4];
	int shield_status[4];
	int shield_action[4];
	int door_status;	 /* 1 = open, 0 = closed, -1 = no docking */
	float door_size;
	int door_side;

	/* Cloak fields */
	char cloak_status;
	int cloak_cost;
	int time_to_cloak;

	int shield_max[4];
	float shield_factor;
	int shield_max_charge[4];  /* max that can be added per turn */

	/* Engineering Allocations */

	int alloc_nav;
	int alloc_shields;
	int alloc_tac;
	int alloc_batt;

	/* Tactical allocations */
	int talloc_guns;
	int talloc_torps;
	int talloc_tractor;

	/* Tractor beam */
	int tractor_status;
	TAG *tractor_target;
	int tractor_power;
	float tractor_effect;

	/* Weapons system fields */
	int free_torp_loaders;
	int num_torps_online;
	int num_guns_online;
	int auto_online;
	int auto_reload;

	int torp_ammo;
	int num_torp_loaders;
	int number_of_torps;
	int number_of_guns;

	char gun_string[40];
	char torp_string[40];

	struct torp_entry torp[MAX_TORPS];
	struct gun_entry gun[MAX_GUNS];

	/* Damage control fields */

	struct damage_entry damage[NUM_SYSTEMS];
	int damcon_teams;
	int team[MAX_TEAMS]; 	 /* shows what each team is up to */

};

#define INVINCIBLE	0x00000001
#define SPEEDY		0x00000002
#define POKEY		0x00000004
#define NAKED		0x00000008
#define DISABLED	0x00000010
#define PACIFIST	0x00000020
#define CAN_LAND	0x00000040

#define Invincible(x)	((x->shipflags & INVINCIBLE) != 0)
#define Speedy(x)	((x->shipflags & SPEEDY) != 0)
#define Pokey(x)	((x->shipflags & POKEY) != 0)
#define Naked(x)	((x->shipflags & NAKED) != 0)
#define Disabled(x)	((x->shipflags & DISABLED) != 0)
#define Pacifist(x)	((x->shipflags & PACIFIST) != 0)
#define CanLand(x)	((x->shipflags & CAN_LAND) != 0)

/* torp tube status values */
#define TORP_EMPTY            0
#define TORP_LOADING          1
#define TORP_LOADED           2
#define TORP_ONLINE           3
#define TORP_ARMED            4
#define TORP_DAMAGED  	5

/* gun status values */
#define GUN_ONLINE           0
#define GUN_OFFLINE          1
#define GUN_DAMAGED          4

/* cloak status values */
#define CLOAK_NONE              0
#define CLOAK_OFF              	1 
#define CLOAK_ON                2
#define CLOAKING		3
#define DECLOAKING		4

/* tractor beam status values */
#define TRACTOR_NONE		0
#define TRACTOR_OFF		1
#define TRACTOR_ON		2
#define TRACTOR_DRAW		3
#define TRACTOR_DAMAGED		4

/* shield status values */
#define SHLD_READY              0
#define SHLD_UP                 1 
#define SHLD_DAMAGED            2

#define SHLD_STABLE             3
#define SHLD_CHARGING           4
#define SHLD_FALLING            5
#define SHLD_OVERLOADED         6 

/* docking bay door values */
#define DOORS_NONE              -1
#define DOORS_CLOSED            0
#define DOORS_OPEN              1

#define CS_COMM_ONLY            0
#define CS_BRIDGE_AUDIO         1
#define CS_VISUALS              2

#define CR_COMM_ONLY            0
#define CR_BRIDGE_AUDIO         1
#define CR_ON_SCREEN            2
 
