/* v0.9
 *
 * damage.h:  Damage module header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

/* ship system identifiers */
#define SYSTEM_SHIELD_FORE      0
#define SYSTEM_SHIELD_AFT       1
#define SYSTEM_SHIELD_PORT      2
#define SYSTEM_SHIELD_STARBOARD 3
#define SYSTEM_SHIELD_DORSAL    4
#define SYSTEM_SHIELD_VENTRAL   5
#define SYSTEM_GUN_0            6
#define SYSTEM_GUN_1            7
#define SYSTEM_GUN_2            8
#define SYSTEM_GUN_3            9
#define SYSTEM_GUN_4            10
#define SYSTEM_GUN_5            11
#define SYSTEM_TORP_0           12
#define SYSTEM_TORP_1           13
#define SYSTEM_TORP_2           14
#define SYSTEM_TORP_3           15
#define SYSTEM_TORP_4           16
#define SYSTEM_TORP_5           17
#define SYSTEM_BATTERIES        18
#define SYSTEM_CLOAK            19
#define SYSTEM_ENGINE           20
#define SYSTEM_SENSORS          21
#define SYSTEM_SCANNERS         22
#define SYSTEM_HULL             23
#define SYSTEM_TRACTOR		24
#define SYSTEM_TRANSPORTER	25

#define WPN_GUN                 0
#define WPN_TORP                1
#define EXPLOSION		2

extern void damInitSystemDamage(TAG *);
extern void damWriteDamage(dbref, SHIP *);
extern void damBattleDamage(XYZ, TAG *, int,  int);
extern void damRepair(TAG *, dbref, int, char *);
extern void damSystemStatus(TAG *, dbref);
extern void damTeamStatus(TAG *, dbref);
extern void damExplosionDamage(int, XYZ, int);
extern void damShipRepairs(int);

/* Damage causing functions. These can destroy the ship, and they
   return 1 if the ship is destroyed, 0 otherwise. */
extern int damDamageShield(TAG *, int, int);
extern int damDamageCloak(TAG *, int);
extern int damDamageBattery(TAG *, int);
extern int damDamageGun(TAG *, int, int);
extern int damDamageTorp(TAG *, int, int);
extern int damDamageEngine(TAG *, int);
extern int damDamageScanner(TAG *, int);
extern int damDamageSensor(TAG *, int);
extern int damDamageTransporter(TAG *, int);
extern int damDamageTractor(TAG *, int);
extern void damSystemDamage(TAG *, int,  int);
