/* v0.9
 *
 * hashtab.c:  Basic hash table code.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include <stdlib.h>
#include <string.h>

#include "pseint.h"
#include "hashtab.h"

enum search_type {NEAR, EXACT};

static HNODE *modified_search(const char *, HNODE *, int);
static HNODE *modified_search_len(const char *, HNODE *, int, int);

static HNODE *modified_search_len(const char *skey, HNODE *table, int type,
				  int len)
{
     int d;
     HNODE *tmp=NULL, *ptr=table;

     while (ptr != NULL) {

	  tmp = ptr;

	  if ((d=strncasecmp(skey, ptr->key, len))==0) return ptr;
	  if (d < 0)
	       ptr=ptr->left_child;
	  else
	       ptr=ptr->right_child;

     }
     return((type == NEAR) ? tmp: NULL);
}

void *hashSearchLen(const char *skey, HNODE *table, int len)
{
    HNODE *ptr;

    ptr = modified_search_len(skey, table, EXACT, len);

    if (ptr != NULL)
	return (ptr->data);
    else
	return NULL;
}

static HNODE *modified_search(const char *skey, HNODE *table, int type)
{
     int d;
     HNODE *tmp=NULL;
     HNODE *ptr=table;

     while (ptr != NULL) {

	  tmp = ptr;

	  if ((d=strcasecmp(skey, ptr->key))==0) return ptr;
	  if (d < 0)
	       ptr=ptr->left_child;
	  else
	       ptr=ptr->right_child;

     }
     return((type == NEAR) ? tmp: NULL);
}

void *hashSearch(const char *skey, HNODE *table)
{
     HNODE *ptr;

     ptr = modified_search(skey, table, EXACT);

     if (ptr != NULL)
	  return(ptr->data);
     else
	  return(NULL);

}

void hashInsert(const char *skey, void *data, HNODE **table)
{
     HNODE *newent, *tmp;
     int d;

     newent = (HNODE *)pse_malloc(sizeof(HNODE));

     newent->key = skey;
     newent->data = data;
     newent->left_child = newent->right_child = NULL;

     if (*table != NULL) {

	  tmp = modified_search(skey, *table, NEAR);
	  d = strcasecmp(skey, tmp->key);
	  if (d == 0)	/* exact match found */
	       return;
	  else if (d < 0) 
	       tmp->left_child = newent;
	  else
	       tmp->right_child = newent;

     } 
     else
	  *table = newent;

     return;

}		

void hashFree(HNODE *hn)
{

     if (hn->left_child != NULL) hashFree(hn->left_child);
     if (hn->right_child != NULL) hashFree(hn->right_child);
     pse_free(hn);

}






