/* v0.9
 *
 * hashtab.h:  Hash table declarations
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#ifndef _HASHTAB_H
#define _HASHTAB_H

typedef struct hash_node HNODE;

struct hash_node {
     HNODE *left_child;
     HNODE *right_child;
     const char *key;
     int *data;
     int free;
};

extern void *hashSearch(const char *, HNODE *);
extern void *hashSearchLen(const char *, HNODE *, int);
extern void hashInsert(const char *, void *, HNODE **);
extern void hashFree(HNODE *);

#endif /* _HASHTAB_H */




