/* v0.9
 *
 * ship.h:  Ship definition.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#ifdef ENABLE_TIME_TRACKER
#include <time.h>
#endif

#ifdef ENABLE_SHIELD_CLASSES
#include "scm/scm.h"
#endif

struct channel_entry {
     unsigned frequency;
     int send_status;
     int receive_status;
     char label[17];
};

struct torp_entry {
     int range;
     float base_accuracy;
     int power;
     int charge;
     int time_to_reload;
     int turns_charged;
     int status;
     int charge_per_turn;
};

struct gun_entry {
    int range;
    int power;
    float range_percent;  /* deliverable percent at max range */
    int charge;
    int old_charge;
    int status;
    int charge_per_turn;
    int arc;
};

struct damage_entry {
     char status;
     int teams;
     int maxteams;
     int time_to_fix;
};

struct console_entry {
     dbref dbref;
     unsigned int flags;
};

#define MAX_CONSOLES	8

#define CONS_NAV		0x0001
#define CONS_TAC		0x0002
#define CONS_ENG		0x0004
#define CONS_SHD		0x0008
#define CONS_TRANS		0x0010
#define CONS_DAM		0x0020
#define CONS_COMM		0x0040

/* Invalid is used when creating the ship. Lets user know everything that's
   wrong with the console in one go, rather than incremental errors. */
#define CONS_INVALID	        0x4000
#define CONS_ACTIVE		0x8000

#define CONS_ISNAV(ship, num)		((ship->consoles[num].type & CONS_NAV)   ? 1:0)
#define CONS_ISTAC(ship, num)		((ship->consoles[num].type & CONS_TAC)   ? 1:0)
#define CONS_ISENG(ship, num)		((ship->consoles[num].type & CONS_ENG)   ? 1:0)
#define CONS_ISSHD(ship, num)		((ship->consoles[num].type & CONS_SHD)   ? 1:0)
#define CONS_ISTRANS(ship, num)		((ship->consoles[num].type & CONS_TRANS) ? 1:0)
#define CONS_ISDAM(ship, num)		((ship->consoles[num].type & CONS_DAM)   ? 1:0)
#define CONS_ISCOMM(ship, num)		((ship->consoles[num].type & CONS_COMM)  ? 1:0)
#define CONS_ISACTIVE(ship, num)	((ship->consoles[num].type & CONS_ACTIVE)? 1:0)

#define CONS_DBREF(ship, num)   (ship->consoles[num].dbref)

struct ship_entry {
    
    /* identification fields */
    char class[CLASS_LEN];
    char type[TYPE_LEN];
    char owner_name[OWNER_LEN];
    int owner;
    
    /* Dbrefs of consoles */
    struct console_entry consoles[MAX_CONSOLES];
    int   num_consoles;
    
    dbref dbref_bridge;
    dbref dbref_eng;
    
    unsigned int shipflags;
    
    /* Hull damage */
    int hull_integrity;
    int current_integrity;
    int permanent_hull_damage;
    
    /* Reactor fields */
    int reactor_output_max;
    int current_reactor_output_max;
    int reactor_setting;
    int reactor_output;
    int reactor_setting_limit;
    int reactor_stress_level;
    int reactor_overload_penalty;
    int reactor_drain;
    
    int max_overload_points;
    int overload_points;
    
    /* Battery fields */   
    int battery_capacity;
    int battery_level;
    int battery_discharge_max;
    int battery_discharge;
    char battery_status;
    
    /* Engineering fields */
    int eng_warnings;
    int eng_safeties;
    
    /* Engine fields */
    float warp_accel;          /* Acceleration rate of the ship */
    float warp_factor;         /* Power vs speed factor */
    float warp_rated_max;      /* Top speed. Higher causes damage */
    float warp_max;            /* Current top speed from power/flags etc */
    float warp_set_speed;      /* Current set speed */
    float warp_speed;          /* Current speed */
    
    int scanner_range;
    
    /* Communications fields */
    float transmitter_range;
    float receiver_sensitivity;
    struct channel_entry channel[MAX_COMM_CHANNELS];
    
    /* Shield/door fields */
    int shield_level[NUM_SHIELDS];
    int shield_alloc[NUM_SHIELDS];
    int shield_status[NUM_SHIELDS];
    int shield_action[NUM_SHIELDS];
    int door_status;	 /* 1 = open, 0 = closed, -1 = no docking */
    float door_size;
    int door_side;
    
    /* Cloak fields */
    char cloak_status;
    int cloak_cost;
    int time_to_cloak;
    
#ifdef ENABLE_SHIELD_CLASSES
    int     sc_num;             /* Number of shield layers on this ship */
    SCLAYER sc[SCM_MAX_LAYERS]; /* Shield layer information list        */
#endif

    /* Eventually the shield class code will replace these, but not yet */
    int shield_max[NUM_SHIELDS];
    float shield_factor;
    int shield_max_charge[NUM_SHIELDS]; /* max that can be added per turn */
    int shield_number;		/* Number of shields for this config */
    int shield_config;		/* Shield configuration */

    /* Engineering Allocations */
    int alloc_nav;
    int alloc_shields;
    int alloc_tac;
    int alloc_batt;
    
    /* Tactical allocations */
    int talloc_guns;
    int talloc_torps;
    int talloc_tractor;
    
    /* Tractor beam */
    int tractor_status;
    TAG *tractor_target;
    int tractor_power;
    float tractor_effect;
    
    /* Weapons system fields */
    int free_torp_loaders;
    int num_torps_online;
    int num_guns_online;
    int auto_online;
    int auto_reload;
    
    int torp_ammo;
    int num_torp_loaders;
    int number_of_torps;
    int number_of_guns;
    
    char gun_string[GUN_LEN];
    char torp_string[TORP_LEN];
    
    struct torp_entry torp[MAX_TORPS];
    struct gun_entry gun[MAX_GUNS];
    
    /* Damage control fields */

    struct damage_entry damage[NUM_SYSTEMS];
    int damcon_teams;
    int team[MAX_TEAMS];	/* shows what each team is up to */

#ifdef ENABLE_ODOMETER
    int odometer;		/* Distance travelled since last reset */
#endif

#ifdef ENABLE_TIME_TRACKER
    time_t time_active;	        /* Time in STATUS_TIME_ACTIVE on startup */
    time_t time_start;		/* time() the object was added to space */
#endif

    float turn_factor;		/* Turn rate multiplier. */
    float roll_factor;		/* Roll rate multiplier. */
};

#define INVINCIBLE	0x00000001
#define SPEEDY		0x00000002
#define POKEY		0x00000004
#define NAKED		0x00000008
#define DISABLED	0x00000010
#define PACIFIST	0x00000020
#define CAN_LAND	0x00000040

#define Invincible(x)	((x->shipflags & INVINCIBLE) != 0)
#define Speedy(x)	((x->shipflags & SPEEDY) != 0)
#define Pokey(x)	((x->shipflags & POKEY) != 0)
#define Naked(x)	((x->shipflags & NAKED) != 0)
#define Disabled(x)	((x->shipflags & DISABLED) != 0)
#define Pacifist(x)	((x->shipflags & PACIFIST) != 0)
#define CanLand(x)	((x->shipflags & CAN_LAND) != 0)

/* torp tube status values */
#define TORP_EMPTY            0
#define TORP_LOADING          1
#define TORP_LOADED           2
#define TORP_ONLINE           3
#define TORP_ARMED            4
#define TORP_DAMAGED          5

/* gun status values */
#define GUN_ONLINE           0
#define GUN_OFFLINE          1
#define GUN_DAMAGED          4

/* cloak status values */
#define CLOAK_NONE              0
#define CLOAK_OFF              	1 
#define CLOAK_ON                2
#define CLOAKING                3
#define DECLOAKING              4

/* tractor beam status values */
#define TRACTOR_NONE		0
#define TRACTOR_OFF    		1
#define TRACTOR_ON     		2
#define TRACTOR_DRAW		3
#define TRACTOR_DAMAGED		4

/* shield status values */
#define SHLD_READY              0
#define SHLD_UP                 1 
#define SHLD_DAMAGED            2

#define SHLD_STABLE             3
#define SHLD_CHARGING           4
#define SHLD_FALLING            5
#define SHLD_OVERLOADED         6 

#define NUM_SHIELD_CONFIGS		5

#define SHIELD_CONFIG_ORIG4		0	/* Original shield setup */
#define SHIELD_CONFIG_ORIG6		1	/* 6 shield setup 1*/
#define SHIELD_CONFIG_CUBE		2	/* 6 shield setup 2*/
#define SHIELD_CONFIG_ORANGE1	3	/* 4 shield setup P,V,S,D */
#define SHIELD_CONFIG_ORANGE2	4	/* 4 shield setup */

/* docking bay door values */
#define DOORS_NONE              -1
#define DOORS_CLOSED            0
#define DOORS_OPEN              1

#define CS_COMM_ONLY            0
#define CS_BRIDGE_AUDIO         1
#define CS_VISUALS              2

#define CR_COMM_ONLY            0
#define CR_BRIDGE_AUDIO         1
#define CR_ON_SCREEN            2
