/* v1.1
 *
 * btreetab.c:  Basic btree table code.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include <stdlib.h>
#include <string.h>

#ifdef WIN32
/* Win32 needs strutil for strcasecmp and friends */
#include <strutil.c>
#endif

#include "pseint.h"
#include "btree.h"

enum search_type {NEAR, EXACT};

static BNODE *modified_search(const char *, BNODE *, int);
static BNODE *modified_search_len(const char *, BNODE *, int, int);

static BNODE *modified_search_len(const char *skey, BNODE *table, int type,
				  int len)
{
     int d;
     BNODE *tmp=NULL, *ptr=table;

     while (ptr != NULL) {

	  tmp = ptr;

	  if ((d=strncasecmp(skey, ptr->key, len))==0) return ptr;
	  if (d < 0)
	       ptr=ptr->left_child;
	  else
	       ptr=ptr->right_child;

     }
     return((type == NEAR) ? tmp: NULL);
}

void *btreeSearchLen(const char *skey, BNODE *table, int len)
{
    BNODE *ptr;

    ptr = modified_search_len(skey, table, EXACT, len);

    if (ptr != NULL)
	return (ptr->data);
    else
	return NULL;
}

static BNODE *modified_search(const char *skey, BNODE *table, int type)
{
     int d;
     BNODE *tmp=NULL;
     BNODE *ptr=table;

     while (ptr != NULL) {

	  tmp = ptr;

	  if ((d=strcasecmp(skey, ptr->key))==0) return ptr;
	  if (d < 0)
	       ptr=ptr->left_child;
	  else
	       ptr=ptr->right_child;

     }
     return((type == NEAR) ? tmp: NULL);
}

void *btreeSearch(const char *skey, BNODE *table)
{
     BNODE *ptr;

     ptr = modified_search(skey, table, EXACT);

     if (ptr != NULL)
	  return(ptr->data);
     else
	  return(NULL);

}

void btreeInsert(const char *skey, void *data, BNODE **table)
{
     BNODE *newent, *tmp;
     int d;

     newent = (BNODE *)pse_malloc(sizeof(BNODE));

     newent->key = skey;
     newent->data = data;
     newent->left_child = newent->right_child = NULL;

     if (*table != NULL) {

	  tmp = modified_search(skey, *table, NEAR);
	  d = strcasecmp(skey, tmp->key);
	  if (d == 0)	/* exact match found */
	       return;
	  else if (d < 0) 
	       tmp->left_child = newent;
	  else
	       tmp->right_child = newent;

     } 
     else
	  *table = newent;

     return;

}		

void btreeFree(BNODE *bn)
{

     if (bn->left_child != NULL) btreeFree(bn->left_child);
     if (bn->right_child != NULL) btreeFree(bn->right_child);
     pse_free(bn);

}
