/* v1.1
 *
 * rxl.h:  Range translation header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#ifndef __RXL_H__
#define __RXL_H__

#define RXL_MAX_NAME_LEN        80   /* Max length of the plugin name */

typedef struct rxl_interface    RXL_INTERFACE;

typedef int (*rxlInitModule_t)(void);
typedef int (*rxlFreeModule_t)(void);
typedef int (*rxlFormatSz_t)(char *, int, range_t, int);

struct rxl_interface {
    char            rxlName[RXL_MAX_NAME_LEN];  /* Unique module identifier */
    int             rxlNameLen;                 /* Length of name           */
    rxlInitModule_t rxlInitModule;              /* Called once during setup */
    rxlFreeModule_t rxlFreeModule;              /* Called once to cleanup   */
    rxlFormatSz_t   rxlFormatSz;                /* Format a range string    */
};

extern void rxlInitModules(void);
extern void rxlFreeModules(void);
extern const char *rxlListRegisteredModules(void);
extern int rxlLookup(const char *);
extern int rxlFormat(int id, char * buff, int maxlen, range_t, int flags);

#define RXLF(tag, a, b, c, d) rxlFormat(tag->rxl_ID, a, b, c, d)

#endif
