/* v1.1
 *
 * scm_hull.c:  Shield Class Module for Hull.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 *
 * Hull Data:
 *
 * <rel> <area> <strength> <max> <cur> <per>
 */

#include <stdlib.h>
#include "../spaceconf.h"

#ifdef ENABLE_SHIELD_CLASSES

#include "../pseint.h"
#include "../dbint.h"
#include "../space.h"
#include "../output.h"
#include "scm.h"

/* Used to track changes to the persistant layer data. Should be incremented
 * when the format of the module specific data changes.
 */
#define MODULE_RELEASE 1

extern SCM_INTERFACE scm_hull;
extern int scm_hull_InitModule();
extern int scm_hull_FreeModule();
extern int scm_hull_LoadLayer(dbref, SCDATA*, const char*);
extern int scm_hull_SaveLayer(SSTR *, SCDATA*);
extern int scm_hull_FreeLayer(SCDATA*);

/* Define the entries needed on the shield class definition object to
 * support this shield class. */

#define CF_HULL_FACTOR     0
#define CF_HULL            1

/*
static VArrayIndex *vidx = NULL;
static VAIDXENTRY vars[] = {

    {"CF_HULL_FACTOR", CF_HULL, VA_TYPE_FLOAT|VA_REQUIRED, 0, NULL},
    {"CF_HULL",        CF_HULL, VA_TYPE_INT|VA_REQUIRED,   0, NULL},
    {"", 0, 0, 0, NULL}
};
*/

/* Define the entries used by the shield class handlers to initialize,
 * free, and use this shield class. */

SCM_INTERFACE scm_hull = {
    "Hull",
    0,
    scm_hull_InitModule,
    scm_hull_FreeModule,
    scm_hull_LoadLayer,
    scm_hull_SaveLayer,
    scm_hull_FreeLayer
};

/* The per instance storage array */

typedef struct scm_hulldata SCM_HULLDATA;

struct scm_hulldata {
    float strength;
    int maximum_integrity;
    int current_integrity;
    int permanent_damage;
};

int scm_hull_InitModule()
{
    /* Create a VArray index from the above table */
    /*
    vidx = vaCreateIndexFromTable(vars);
    if (vidx == NULL)
	return 0;
    */

    return 1;
}

int scm_hull_FreeModule()
{
    /* Free the VArray index if we created it */
    /*
    if (vidx) {
	vaFreeIndex(vidx);
	vidx = NULL;
    }
    */

    /* Do any other cleanup here */
    
    return 1;
}

/*
 * Called when creating a new object. Needs to initialise any local
 * storage that's needed.
 */
int scm_hull_LoadLayer(dbref data, SCDATA *inst, const char *szData)
{
    int rel;
    SCAREAS *area;
    SCM_HULLDATA *hd;
    
    /* Parse up the storage string */
    szData = scmParseData(szData, &rel, &area);
    
    /* szData is a now a pointer to the real module data */
    hd = pse_malloc(sizeof(SCM_HULLDATA));

    sscanf(szData, "%f %d %d %d", &hd->strength, &hd->maximum_integrity,
	   &hd->current_integrity,
	   &hd->permanent_damage);
    
    inst->storage = hd;
    
    return 1;
}

/*
 * Called when storing an object. Should set ps to the entire output
 * string, including module release and area data. Return 0 on an error.
 */
int scm_hull_SaveLayer(SSTR *ps, SCDATA *inst)
{
    SCM_HULLDATA *hd;
    
    hd = inst->storage;
    
    sstr_sprintf(ps, "%d %s %f %d %d %d", MODULE_RELEASE, "Area",
		 hd->strength, hd->maximum_integrity, hd->current_integrity,
		 hd->permanent_damage);

    return 1;
}

/*
 * Called when freeing an object. Needs to discard any persistant data
 * storage.
 */
int scm_hull_FreeLayer(SCDATA *inst)
{
    if (inst->storage != NULL) {
	pse_free(inst->storage);
	inst->storage = NULL;
    }
    
    return 1;
}

#endif
