/* v1.1
 * 
 * spaceconf.h:	Space engine hard-configurable options
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

/* 
 * Note:  Please let me know what should be made configurable!
 */

/*
 * 1.  Configure size parameters.
 */


/* Number of spaces.  Space 0 is always real space, and 1+ are sim spaces.
 */

#define NUM_SPACES		20

/* Maximum attribute length.  This defines the maximum length
 * of the attributes that are accessed by the space engine, both
 * before and after any functions are evaluated.  Note that if
 * this number is too small, the space engine may truncate 
 * attributes or (worse) crash.  If the number is too large, the
 * engine will consume extra memory needlessly.
 */

#define MAX_ATTRIBUTE_LEN 5000

/*
 * 2.  Configure feature set.
 *	Choose the features that your space system will incorporate.
 *	(Currently all features enabled.)
 */

/* Log new contacts, and contacts lost? */

/* #define LOG_CONTACTS */

/* Odometer tracking.
 * 
 * Uncomment the next line to enable travelled distance tracking. Each ship
 * will have an odometer to measure the total distance travelled. See the
 * documentation for more information about this feature.
 */

#define ENABLE_ODOMETER

/* Time Tracker.
 *
 * Uncomment the next line to keep track of total time spent in space by each
 * ship. This counter tracks the total amount of time that a ship has been
 * active.
 */

#define ENABLE_TIME_TRACKER

/* Enable the new shield class code. This code will replace the current
 * code handling shields and hull damage by providing a very flexible
 * means of adding layers of protection to a ship.  Each ship will be
 * able to have a number of layers of shields of various classes and
 * with various properties.
 * NOTE: THIS CODE IS INCOMPLETE AND SHOULD NOT BE ENABLED YET.
 */

#define ENABLE_SHIELD_CLASSES

/* Enable this to use floating point coordinates, speeds etc in output
 * to softcode.  Note that the engine is all floating point internally.
 */

#define ENABLE_FLOATS

/* Enable this to add turn-based update support. With this enabled, automatic
 * space updates do *not* happen every second. Calling the run_cycle(space)
 * spacecall enables a flag for that space.  This flag is checked every
 * second, and if it is set, the cycle is performed.
 */

/* #define ENABLE_TURN_BASED */

/* Enable additional runtime debugging checks. Generally this should be
 * turned off for performance reasons, but if you have strange problems,
 * recompile with this enabled as the extra information may help track down
 * the bug
 */

/* #define ENABLE_DEBUGGING */

/* The macro used to decide if snprintf() truncated the string. For Linux
 * snprintf returns -1 if the string was truncated.
 */

#define TRUNCSTR(a) (a == -1)

/* Defining this causes a smoother response from the PSE by performing
 * all the movement, sensors, events, damage etc to happen every second
 * rather than spread over a 6 second update cycle.  This is for those
 * of you with CPU to burn.
 */
#define ENABLE_REALTIME

/* Defining this reduces the amount of directly-emitted noise from PSE.
 * Where possible, and an alternate means exists to accomplish the same
 * function, direct emits are removed.
 *
 * For instance, for the bay door control, direct emits are skipped, and
 * it is up to the space coder to notify the players of the change in
 * status
 */
/* #define ENABLE_SILENCE */
